package service;

/**
 * Implements the patter "Abstract Factory" http://en.wikipedia.org/wiki/Abstract_factory_pattern
 * that allows to create class that use the classes of the package service without 
 * that this classes have any references to the implementation of any class of this 
 * package.   
 */
public interface ServiceFactory {
	/**
	 * Return a new object of the class SimpleState
	 * @param name the name of the state
	 * @param isInitial this variable must be true if the state will be a initial state
	 * @param isFinal this variable must be true if the state will be a final state
	 */
	public SimpleState createSimpleState(String name,boolean isInitial,boolean isFinal);
	/**
	 * Return a new object of the class SimpleAction
	 * @param name the name of the action
	 * @param from the source state of the action
	 * @param to the target state of the action
	 */
	public SimpleTransition createSimpleAction(String name,State from,State to);

	/**
	 * Return a new object of the class ComposedState
	 * @param name the name of the state
	 * @param states array of states that make up the ComposedState
	 */
	public ComposedState createComposedState(String name, State[] states);

	
	public ComposedState createComposedState(State[] states);
	/**
	 * Return a new object of the class ComposedAction
	 * @param name the name of the action
	 * @param ts the transition system related to the ComposedAction
	 * @param from the source state of the action
	 * @param to the target state of the aciton
	 */
	public ComposedTransition createComposedAction(String name, TransitionSystem<? extends State,? extends Transition> ts,ComposedState from,ComposedState to);
	/**
	 * Return a new object of the class TransitionSystem that use SimpleState and SimpleAction
	 */
	public TransitionSystem<SimpleState,SimpleTransition> createSimpleTransitionSystem();
	/**
	 * Return a new object of the class TransitionSystem that use SimpleState and SimpleAction,
	 * it is initialized with the TransitionSystem contained in nameFile   
	 * @param nameFile the path of the file that contain the description of the TransitionSystem
	 */
	public TransitionSystem<SimpleState,SimpleTransition> createSimpleTransitionSystem(String nameFile) throws Exception;
	/**
	 * Return a new object of the class TransitionSystem that use ComposedState and ComposedAction
	 */
	public TransitionSystem<ComposedState,ComposedTransition> createComposedTransitionSystem();
}
